/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerRoofStairsOverhangComponent
extends TowerRoofComponent {
    public TowerRoofStairsOverhangComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRStO.get(), nbt);
    }

    public TowerRoofStairsOverhangComponent(int i, TowerWingComponent wing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFLTRStO.get(), i, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.size = wing.size + 2;
        this.height = this.size / 2;
        this.f_73383_ = new BoundingBox(wing.m_73547_().m_162395_() - 1, wing.m_73547_().m_162400_(), wing.m_73547_().m_162398_() - 1, wing.m_73547_().m_162399_() + 1, wing.m_73547_().m_162400_() + this.height - 1, wing.m_73547_().m_162401_() + 1);
    }

    @Override
    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState woodenSlab = Blocks.f_50400_.m_49966_();
        BlockState woodenPlanks = Blocks.f_50742_.m_49966_();
        BlockState birchStairsNorth = (BlockState)Blocks.f_50270_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.NORTH);
        BlockState birchStairsSouth = (BlockState)Blocks.f_50270_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.SOUTH);
        BlockState birchStairsEast = (BlockState)Blocks.f_50270_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.EAST);
        BlockState birchStairsWest = (BlockState)Blocks.f_50270_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)Direction.WEST);
        for (int y = 0; y <= this.height; ++y) {
            int min = y;
            int max = this.size - y - 1;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    if (x == min) {
                        if (z == min || z == max) {
                            this.m_73434_(world, woodenSlab, x, y, z, sbb);
                            continue;
                        }
                        this.m_73434_(world, birchStairsWest, x, y, z, sbb);
                        continue;
                    }
                    if (x == max) {
                        if (z == min || z == max) {
                            this.m_73434_(world, woodenSlab, x, y, z, sbb);
                            continue;
                        }
                        this.m_73434_(world, birchStairsEast, x, y, z, sbb);
                        continue;
                    }
                    if (z == max) {
                        this.m_73434_(world, birchStairsSouth, x, y, z, sbb);
                        continue;
                    }
                    if (z == min) {
                        this.m_73434_(world, birchStairsNorth, x, y, z, sbb);
                        continue;
                    }
                    this.m_73434_(world, woodenPlanks, x, y, z, sbb);
                }
            }
        }
    }
}

